"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "facilityRoutes", {
    enumerable: true,
    get: function() {
        return facilityRoutes;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const facilityRoutes = _express.default.Router();
facilityRoutes.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    const { store, user } = req;
    const { Facility, User } = store.models;
    const userEntity = await User.findByPk(user.id);
    const allowed = await userEntity.allowedFacilityIds();
    const facilities = await Facility.findAll({
        where: allowed === _constants.CAN_ACCESS_ALL_FACILITIES ? {} : {
            id: {
                [_sequelize.Op.in]: allowed
            }
        }
    });
    const data = facilities.map((f)=>f.forResponse());
    res.send({
        count: facilities.length,
        data
    });
}));

//# sourceMappingURL=facility.js.map