export function enumerate(iterable: any): Generator<any[], void, unknown>;
/**
 * Implements a simple tuple tokeniser and parser for a composite record literal.
 *
 * > The composite output routine will put double quotes around field values if they are empty
 * > strings or contain parentheses, commas, double quotes, backslashes, or white space. (Doing
 * > so for white space is not essential, but aids legibility.) Double quotes and backslashes
 * > embedded in field values will be doubled.
 *
 * @see https://www.postgresql.org/docs/current/rowtypes.html#ROWTYPES-IO-SYNTAX
 */
export function parse(raw: any): (string | null)[];
//# sourceMappingURL=parse.d.ts.map