"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "EncounterRecordPrintout", {
    enumerable: true,
    get: function() {
        return EncounterRecordPrintout;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _lodash = require("lodash");
const _constants = require("@tamanu/constants");
const _Layout = require("./Layout");
const _LetterheadSection = require("./LetterheadSection");
const _PatientDetailsWithAddress = require("./printComponents/PatientDetailsWithAddress");
const _getDisplayDate = require("./getDisplayDate");
const _EncounterDetailsExtended = require("./printComponents/EncounterDetailsExtended");
const _MultiPageHeader = require("./printComponents/MultiPageHeader");
const _patientAccessors = require("../patientAccessors");
const _Footer = require("./printComponents/Footer");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
const _dateTime = require("@tamanu/utils/dateTime");
const _medication = require("../medication");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const borderStyle = '1 solid black';
const pageStyles = _renderer.StyleSheet.create({
    body: {
        paddingHorizontal: 50,
        paddingTop: 30,
        paddingBottom: 50
    }
});
const textStyles = _renderer.StyleSheet.create({
    sectionTitle: {
        fontFamily: 'Helvetica-Bold',
        marginBottom: 3,
        fontSize: 11,
        fontWeight: 500
    },
    tableColumnHeader: {
        fontFamily: 'Helvetica-Bold',
        fontSize: 10
    },
    tableCellContent: {
        fontFamily: 'Helvetica',
        fontSize: 10
    },
    tableCellFooter: {
        fontFamily: 'Helvetica',
        fontSize: 8
    },
    headerLabel: {
        fontSize: 8,
        fontFamily: 'Helvetica-Bold',
        fontWeight: 400,
        color: '#888888'
    },
    headerValue: {
        fontSize: 8,
        fontWeight: 400,
        fontFamily: 'Helvetica',
        color: '#888888'
    }
});
const tableStyles = _renderer.StyleSheet.create({
    table: {
        flexDirection: 'column',
        marginBottom: 5
    },
    row: {
        flexDirection: 'row',
        justifyContent: 'space-evenly',
        borderTop: borderStyle,
        borderRight: borderStyle,
        borderBottom: borderStyle,
        marginBottom: -1
    },
    notesRow: {
        flexDirection: 'row',
        justifyContent: 'space-evenly',
        borderTop: borderStyle,
        marginBottom: -1
    },
    baseCell: {
        flexDirection: 'row',
        borderLeft: borderStyle,
        alignItems: 'flex-start',
        padding: 7
    },
    p: {
        fontFamily: 'Helvetica',
        fontSize: 10
    },
    notesCell: {
        width: '100%',
        flexDirection: 'column',
        borderLeft: borderStyle,
        borderRight: borderStyle,
        borderBottom: borderStyle,
        alignItems: 'flex-start',
        padding: 7
    },
    notesFooter: {
        flexDirection: 'row',
        alignItems: 'flex-start'
    }
});
const Table = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: tableStyles.table,
        ...props
    });
const Row = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            tableStyles.row,
            props.width && {
                width: props.width,
                justifyContent: 'start'
            }
        ],
        ...props
    });
const P = ({ style = {}, bold, children })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: bold,
        style: [
            tableStyles.p,
            style
        ]
    }, children);
const Cell = ({ children, style = {} })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            tableStyles.baseCell,
            style
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, null, children));
const HeaderCell = ({ children, style })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            tableStyles.baseCell,
            style
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, {
        bold: true
    }, children));
const NotesCell = ({ children, style = {} })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            tableStyles.notesCell,
            style
        ]
    }, children);
const SectionSpacing = ()=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            paddingBottom: '10px'
        }
    });
const MultipageTableHeading = ({ title, style = textStyles.sectionTitle })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    let firstPageOccurrence = Number.MAX_SAFE_INTEGER;
    return /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        fixed: true,
        style: style,
        render: ({ pageNumber, subPageNumber })=>{
            if (pageNumber < firstPageOccurrence && subPageNumber) {
                firstPageOccurrence = pageNumber;
            }
            return pageNumber === firstPageOccurrence ? title : `${title} ${getTranslation('pdf.heading.contentContinued', 'cont...')}`;
        }
    });
};
const DataTableHeading = ({ columns, title, width })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        fixed: true
    }, /*#__PURE__*/ _react.default.createElement(MultipageTableHeading, {
        title: title
    }), /*#__PURE__*/ _react.default.createElement(Row, {
        wrap: false,
        width: width
    }, columns.map(({ key, title, style })=>{
        if (Array.isArray(title)) {
            return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
                key: key,
                style: [
                    tableStyles.baseCell,
                    {
                        flexDirection: 'column',
                        padding: 4
                    },
                    style
                ]
            }, /*#__PURE__*/ _react.default.createElement(P, {
                style: {
                    fontFamily: 'Helvetica-Bold'
                }
            }, title[0]), /*#__PURE__*/ _react.default.createElement(P, null, title[1]));
        }
        return /*#__PURE__*/ _react.default.createElement(HeaderCell, {
            key: key,
            style: style
        }, title);
    })));
};
const DataTable = ({ data, columns, title, type })=>{
    let width = null;
    if (type === 'vitals' && columns.length <= 12) {
        width = 138 + (columns.length - 1) * 50 + 'px';
    }
    return /*#__PURE__*/ _react.default.createElement(Table, null, /*#__PURE__*/ _react.default.createElement(DataTableHeading, {
        columns: columns,
        title: title,
        width: width
    }), data.map((row)=>/*#__PURE__*/ _react.default.createElement(Row, {
            key: row.id,
            wrap: false,
            width: width
        }, columns.map(({ key, accessor, style })=>/*#__PURE__*/ _react.default.createElement(Cell, {
                key: key,
                style: style
            }, accessor ? accessor(row) : row[key] || '')))));
};
const TableSection = ({ title, data, columns, type })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        minPresenceAhead: 70
    }), /*#__PURE__*/ _react.default.createElement(DataTable, {
        data: data,
        columns: columns,
        title: title,
        type: type
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null));
};
const NoteFooter = ({ note })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: textStyles.tableCellFooter
    }, [
        note.noteType === _constants.NOTE_TYPES.TREATMENT_PLAN && `${getTranslation('general.lastUpdated.label', 'Last updated')}:`,
        note.author?.displayName,
        note.onBehalfOf && getTranslation('note.table.onBehalfOf', 'on behalf of :changeOnBehalfOfName', {
            replacements: {
                changeOnBehalfOfName: note.onBehalfOf.displayName
            }
        }),
        (0, _dateTime.formatShort)(note.date),
        (0, _getDisplayDate.getDisplayDate)(note.date, 'h:mma')
    ].filter(Boolean).join(' '));
};
const NotesMultipageCellPadding = ()=>{
    let firstPageOccurrence = Number.MAX_SAFE_INTEGER;
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        fixed: true,
        render: ({ pageNumber, subPageNumber })=>{
            if (pageNumber < firstPageOccurrence && subPageNumber) {
                firstPageOccurrence = pageNumber;
            }
            return pageNumber !== firstPageOccurrence && /*#__PURE__*/ _react.default.createElement(_renderer.View, {
                style: {
                    paddingBottom: 7
                }
            });
        }
    });
};
const NotesSection = ({ notes })=>{
    const { getTranslation, getEnumTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        minPresenceAhead: 80
    }), /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(MultipageTableHeading, {
        title: getTranslation('general.notes.label', 'Notes')
    }), /*#__PURE__*/ _react.default.createElement(Table, null, notes.map((note)=>/*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            minPresenceAhead: 80
        }), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: tableStyles.notesRow,
            key: note.id
        }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: {
                borderTop: borderStyle,
                position: 'absolute',
                top: -1,
                right: 0,
                left: 0
            },
            fixed: true
        }), /*#__PURE__*/ _react.default.createElement(NotesCell, null, /*#__PURE__*/ _react.default.createElement(NotesMultipageCellPadding, null), /*#__PURE__*/ _react.default.createElement(MultipageTableHeading, {
            title: getEnumTranslation(_constants.NOTE_TYPE_LABELS, note.noteType),
            style: textStyles.tableColumnHeader
        }), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
            style: textStyles.tableCellContent
        }, `${note.content}\n`), /*#__PURE__*/ _react.default.createElement(NoteFooter, {
            note: note
        }), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: {
                borderBottom: borderStyle,
                position: 'absolute',
                bottom: -1,
                right: -1,
                left: -1
            },
            fixed: true
        }))))))));
};
const EncounterRecordPrintoutComponent = ({ patientData, encounter, certificateData, encounterTypeHistory, locationHistory, diagnoses, procedures, labRequests, imagingRequests, notes, discharge, medications, getLocalisation, vitalsData, recordedDates, getVitalsColumn })=>{
    const { getTranslation, getEnumTranslation } = (0, _languageContext.useLanguageContext)();
    const { watermark, logo } = certificateData;
    const COLUMNS = {
        encounterTypes: [
            {
                key: 'encounterType',
                title: getTranslation('encounter.type.label', 'Type'),
                accessor: ({ newEncounterType })=>getEnumTranslation(_constants.ENCOUNTER_TYPE_LABELS, newEncounterType),
                style: {
                    width: '65%'
                }
            },
            {
                key: 'dateMoved',
                title: getTranslation('pdf.encounterRecord.dateAndTimeMoved', 'Date & time moved'),
                accessor: ({ date })=>date ? `${(0, _dateTime.formatShort)(date)} ${(0, _dateTime.formatTime)(date)}` : '--/--/---- --:----',
                style: {
                    width: '35%'
                }
            }
        ],
        locations: [
            {
                key: 'to',
                title: getTranslation('general.localisedField.locationGroupId.label', 'Area'),
                accessor: ({ newLocationGroup })=>(0, _lodash.startCase)(newLocationGroup) || '----',
                style: {
                    width: '30%'
                }
            },
            {
                key: 'location',
                title: getTranslation('general.localisedField.locationId.label', 'Location'),
                accessor: ({ newLocation })=>(0, _lodash.startCase)(newLocation),
                style: {
                    width: '35%'
                }
            },
            {
                key: 'dateMoved',
                title: getTranslation('pdf.encounterRecord.dateAndTimeMoved', 'Date & time moved'),
                accessor: ({ date })=>date ? `${(0, _dateTime.formatShort)(date)} ${(0, _dateTime.formatTime)(date)}` : '--/--/---- --:----',
                style: {
                    width: '35%'
                }
            }
        ],
        diagnoses: [
            {
                key: 'diagnosis',
                title: getTranslation('general.localisedField.diagnosis.label', 'Diagnosis'),
                accessor: ({ diagnosis })=>`${diagnosis?.name} (${diagnosis?.code})`,
                style: {
                    width: '55%'
                }
            },
            {
                key: 'type',
                title: getTranslation('encounter.type.label', 'Type'),
                accessor: ({ isPrimary })=>isPrimary ? 'Primary' : 'Secondary',
                style: {
                    width: '20%'
                }
            },
            {
                key: 'date',
                title: getTranslation('general.date.label', 'Date'),
                accessor: ({ date })=>date ? (0, _dateTime.formatShort)(date) : '--/--/----',
                style: {
                    width: '25%'
                }
            }
        ],
        procedures: [
            {
                key: 'procedure',
                title: getTranslation('procedure.procedureType.label', 'Procedure'),
                accessor: ({ procedureType })=>`${procedureType?.name} (${procedureType?.code})`,
                style: {
                    width: '75%'
                }
            },
            {
                key: 'procedureDate',
                title: getTranslation('procedure.date.label', 'Procedure date'),
                accessor: ({ date })=>date ? (0, _dateTime.formatShort)(date) : '--/--/----',
                style: {
                    width: '25%'
                }
            }
        ],
        labRequests: [
            {
                key: 'testType',
                title: getTranslation('lab.testType.label', 'Test type'),
                style: {
                    width: '20%'
                }
            },
            {
                key: 'testCategory',
                title: getTranslation('lab.testCategory.label', 'Test category'),
                style: {
                    width: '25%'
                }
            },
            {
                key: 'requestedByName',
                title: getTranslation('general.requestedBy.label', 'Requested by'),
                style: {
                    width: '20%'
                }
            },
            {
                key: 'requestDate',
                title: getTranslation('general.requestDate.label', 'Request date'),
                accessor: ({ requestDate })=>requestDate ? (0, _dateTime.formatShort)(requestDate) : '--/--/----',
                style: {
                    width: '17.5%'
                }
            },
            {
                key: 'publishedDate',
                title: getTranslation('pdf.encounterRecord.publishedDate', 'Published date'),
                accessor: ({ publishedDate })=>publishedDate ? (0, _dateTime.formatShort)(publishedDate) : '--/--/----',
                style: {
                    width: '17.5%'
                }
            }
        ],
        imagingRequests: [
            {
                key: 'imagingType',
                title: getTranslation('general.requestType.label', 'Request type'),
                accessor: ({ imagingName })=>imagingName?.label,
                style: {
                    width: '17%'
                }
            },
            {
                key: 'areaToBeImaged',
                title: getTranslation('imaging.areas.label', 'Areas to be imaged'),
                accessor: (imagingRequest)=>imagingRequest?.areas?.length ? imagingRequest?.areas.map((area)=>area.name).join(', ') : imagingRequest?.areaNote,
                style: {
                    width: '25%'
                }
            },
            {
                key: 'requestedBy',
                title: getTranslation('general.requestedBy.label', 'Requested by'),
                accessor: ({ requestedBy })=>requestedBy?.displayName,
                style: {
                    width: '18%'
                }
            },
            {
                key: 'requestDate',
                title: getTranslation('general.requestDate.label', 'Request date'),
                accessor: ({ requestedDate })=>requestedDate ? (0, _dateTime.formatShort)(requestedDate) : '--/--/----',
                style: {
                    width: '20%'
                }
            },
            {
                key: 'completedDate',
                title: getTranslation('pdf.encounterRecord.completedDate', 'Completed date'),
                accessor: (imagingRequest)=>imagingRequest?.results[0]?.completedAt ? (0, _dateTime.formatShort)(imagingRequest?.results[0]?.completedAt) : '--/--/----',
                style: {
                    width: '20%'
                }
            }
        ],
        medications: [
            {
                key: 'medication',
                title: getTranslation('medication.medication.label', 'Medication'),
                accessor: ({ medication })=>medication?.name,
                style: {
                    width: '21%'
                }
            },
            {
                key: 'dose',
                title: getTranslation('pdf.table.column.dose', 'Dose'),
                accessor: (medication)=>{
                    return /*#__PURE__*/ _react.default.createElement(_Text.Text, null, (0, _medication.getDose)(medication, getTranslation, getEnumTranslation), medication?.isPrn && ` ${getTranslation('medication.table.prn', 'PRN')}`);
                },
                style: {
                    width: '9%'
                }
            },
            {
                key: 'frequency',
                title: getTranslation('pdf.table.column.frequency', 'Frequency'),
                accessor: ({ frequency })=>(0, _medication.getTranslatedFrequency)(frequency, getTranslation),
                style: {
                    width: '19%'
                }
            },
            {
                key: 'route',
                title: getTranslation('medication.route.label', 'Route'),
                accessor: ({ route })=>route ? getEnumTranslation(_constants.DRUG_ROUTE_LABELS, route) : '',
                style: {
                    width: '10%'
                }
            },
            {
                key: 'prescriber',
                title: getTranslation('medication.prescriber.label', 'Prescriber'),
                accessor: ({ prescriber })=>prescriber?.displayName,
                style: {
                    width: '18%'
                }
            },
            {
                key: 'prescriptionDate',
                title: getTranslation('medication.date.label', 'Prescription date'),
                accessor: ({ date })=>date ? (0, _dateTime.formatShort)(date) : '--/--/----',
                style: {
                    width: '23%'
                }
            }
        ]
    };
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: pageStyles.body,
        wrap: true
    }, watermark && /*#__PURE__*/ _react.default.createElement(_Layout.Watermark, {
        src: watermark
    }), /*#__PURE__*/ _react.default.createElement(_MultiPageHeader.MultiPageHeader, {
        documentName: discharge ? getTranslation('pdf.encounterRecord.title', 'Patient encounter record') : getTranslation('pdf.encounterProgressRecord.title', 'Patient encounter progress record'),
        patientId: patientData.displayId,
        patientName: (0, _patientAccessors.getName)(patientData)
    }), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logo,
        certificateTitle: discharge ? getTranslation('pdf.encounterRecord.title', 'Patient encounter record') : getTranslation('pdf.encounterProgressRecord.title', 'Patient encounter progress record'),
        letterheadConfig: certificateData
    })), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), /*#__PURE__*/ _react.default.createElement(_PatientDetailsWithAddress.PatientDetailsWithAddress, {
        getLocalisation: getLocalisation,
        patient: patientData
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), /*#__PURE__*/ _react.default.createElement(_EncounterDetailsExtended.EncounterDetailsExtended, {
        encounter: encounter,
        discharge: discharge
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), encounterTypeHistory.length > 0 && /*#__PURE__*/ _react.default.createElement(TableSection, {
        title: getTranslation('pdf.encounterRecord.section.encounterTypes', 'Encounter types'),
        data: encounterTypeHistory,
        columns: COLUMNS.encounterTypes
    }), locationHistory.length > 0 && /*#__PURE__*/ _react.default.createElement(TableSection, {
        title: getTranslation('general.localisedField.locationId.label', 'Location'),
        data: locationHistory,
        columns: COLUMNS.locations
    }), diagnoses.length > 0 && /*#__PURE__*/ _react.default.createElement(TableSection, {
        title: getTranslation('general.localisedField.diagnosis.label', 'Diagnosis'),
        data: diagnoses,
        columns: COLUMNS.diagnoses
    }), procedures.length > 0 && /*#__PURE__*/ _react.default.createElement(TableSection, {
        title: getTranslation('discharge.procedures.label', 'Procedures'),
        data: procedures,
        columns: COLUMNS.procedures
    }), labRequests.length > 0 && /*#__PURE__*/ _react.default.createElement(TableSection, {
        title: getTranslation('pdf.encounterRecord.section.labRequests', 'Lab requests'),
        data: labRequests,
        columns: COLUMNS.labRequests
    }), imagingRequests.length > 0 && /*#__PURE__*/ _react.default.createElement(TableSection, {
        title: getTranslation('pdf.encounterRecord.section.imagingRequests', 'Imaging requests'),
        data: imagingRequests,
        columns: COLUMNS.imagingRequests
    }), medications.length > 0 && /*#__PURE__*/ _react.default.createElement(TableSection, {
        title: getTranslation('pdf.encounterRecord.section.medications', 'Medications'),
        data: medications,
        columns: COLUMNS.medications
    }), notes.length > 0 && /*#__PURE__*/ _react.default.createElement(NotesSection, {
        notes: notes
    }), /*#__PURE__*/ _react.default.createElement(_Footer.Footer, null)), vitalsData.length > 0 && recordedDates.length > 0 ? /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, [
        0,
        12,
        24,
        36,
        48
    ].map((start)=>{
        return recordedDates.length > start ? /*#__PURE__*/ _react.default.createElement(_Page.Page, {
            size: "A4",
            orientation: "landscape",
            style: pageStyles.body
        }, /*#__PURE__*/ _react.default.createElement(_MultiPageHeader.MultiPageHeader, {
            documentName: discharge ? getTranslation('pdf.encounterRecord.title', 'Patient encounter record') : getTranslation('pdf.encounterProgressRecord.title', 'Patient encounter progress record'),
            patientId: patientData.displayId,
            patientName: (0, _patientAccessors.getName)(patientData)
        }), /*#__PURE__*/ _react.default.createElement(TableSection, {
            title: getTranslation('pdf.encounterRecord.section.vitals', 'Vitals'),
            data: vitalsData,
            columns: getVitalsColumn(start),
            type: "vitals"
        }), /*#__PURE__*/ _react.default.createElement(_Footer.Footer, null)) : null;
    })) : null);
};
const EncounterRecordPrintout = (0, _languageContext.withLanguageContext)(EncounterRecordPrintoutComponent);

//# sourceMappingURL=EncounterRecordPrintout.js.map