"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SurveyResponsesPrintout", {
    enumerable: true,
    get: function() {
        return SurveyResponsesPrintout;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _constants = require("@tamanu/constants");
const _Layout = require("./Layout");
const _LetterheadSection = require("./LetterheadSection");
const _MultiPageHeader = require("./printComponents/MultiPageHeader");
const _patientAccessors = require("../patientAccessors");
const _Footer = require("./printComponents/Footer");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
const _PatientDetails = require("./printComponents/PatientDetails");
const _surveyAnswers = require("./surveyAnswers");
const _SurveyResponseDetails = require("./printComponents/SurveyResponseDetails");
const _dateTime = require("@tamanu/utils/dateTime");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const pageStyles = _renderer.StyleSheet.create({
    body: {
        paddingHorizontal: 50,
        paddingTop: 30,
        paddingBottom: 50
    },
    groupContainer: {
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'space-between',
        flexWrap: 'wrap',
        marginBottom: 4
    },
    item: {
        width: 238,
        display: 'flex',
        flexDirection: 'column',
        gap: 2,
        paddingBottom: 4,
        borderBottom: '0.5px solid black',
        marginBottom: 8,
        alignSelf: 'flex-end'
    },
    itemText: {
        fontSize: 9
    },
    boldText: {
        fontFamily: 'Helvetica-Bold'
    },
    boldDivider: {
        borderBottom: '2px solid black',
        height: 2,
        width: '100%',
        marginTop: '-6px'
    },
    resultBox: {
        paddingTop: 7,
        paddingLeft: 11,
        paddingBottom: 6,
        marginBottom: 14,
        fontSize: 11,
        border: '0.5px solid black',
        gap: 5
    },
    robotoFont: {
        fontFamily: 'Roboto'
    }
});
const SectionSpacing = ({ height })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            paddingBottom: height ?? '10px'
        }
    });
const ResultBox = ({ resultText, resultName })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: pageStyles.resultBox
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, null, resultName), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: [
            pageStyles.itemText,
            pageStyles.robotoFont
        ]
    }, resultText));
const getAnswers = ({ answer, sourceType, type })=>{
    switch(sourceType || type){
        case _constants.PROGRAM_DATA_ELEMENT_TYPES.RESULT:
            {
                const { strippedResultText } = (0, _surveyAnswers.separateColorText)(answer);
                return strippedResultText;
            }
        case _constants.PROGRAM_DATA_ELEMENT_TYPES.CALCULATED:
            return parseFloat(answer).toFixed(1);
        case _constants.PROGRAM_DATA_ELEMENT_TYPES.PHOTO:
            return 'Image file - Refer to Tamanu to view';
        case _constants.PROGRAM_DATA_ELEMENT_TYPES.SUBMISSION_DATE:
            return (0, _dateTime.formatShort)(answer);
        case _constants.PROGRAM_DATA_ELEMENT_TYPES.DATE:
            return (0, _dateTime.formatShort)(answer);
        case _constants.PROGRAM_DATA_ELEMENT_TYPES.MULTI_SELECT:
            return JSON.parse(answer).join(', ');
        default:
            return answer;
    }
};
const ResponseItem = ({ row })=>{
    const { name, answer, type, sourceType } = row;
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: pageStyles.item,
        wrap: false
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: pageStyles.itemText
    }, name), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: [
            pageStyles.itemText,
            pageStyles.boldText
        ]
    }, getAnswers({
        answer,
        type,
        sourceType
    })));
};
const ResponsesGroup = ({ rows })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: pageStyles.groupContainer
    }, rows.map((row)=>/*#__PURE__*/ _react.default.createElement(ResponseItem, {
            key: row.id,
            row: row
        })), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: pageStyles.boldDivider
    }));
};
const SurveyResponsesPrintoutComponent = ({ patientData, certificateData, getLocalisation, surveyResponse, isReferral, facility, currentUser })=>{
    const { watermark, logo } = certificateData;
    const surveyAnswerRows = (0, _surveyAnswers.getSurveyAnswerRows)(surveyResponse).filter(({ answer })=>answer);
    const groupedAnswerRows = Object.values(surveyAnswerRows.reduce((acc, item)=>{
        if (!acc[item.screenIndex]) {
            acc[item.screenIndex] = [];
        }
        acc[item.screenIndex].push(item);
        return acc;
    }, {}));
    const { strippedResultText } = (0, _surveyAnswers.separateColorText)(surveyResponse.resultText);
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: pageStyles.body
    }, watermark && /*#__PURE__*/ _react.default.createElement(_Layout.Watermark, {
        src: watermark
    }), /*#__PURE__*/ _react.default.createElement(_MultiPageHeader.MultiPageHeader, {
        documentName: !isReferral ? 'Program form' : 'Referral',
        documentSubname: surveyResponse.title,
        patientId: patientData.displayId,
        patientName: (0, _patientAccessors.getName)(patientData)
    }), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        getLocalisation: getLocalisation,
        logoSrc: logo,
        certificateTitle: !isReferral ? 'Program form' : 'Referral',
        certificateSubtitle: surveyResponse.title,
        letterheadConfig: certificateData
    })), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), /*#__PURE__*/ _react.default.createElement(_PatientDetails.PatientDetails, {
        getLocalisation: getLocalisation,
        patient: patientData
    }), /*#__PURE__*/ _react.default.createElement(_SurveyResponseDetails.SurveyResponseDetails, {
        surveyResponse: surveyResponse
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, {
        height: 16
    }), strippedResultText && /*#__PURE__*/ _react.default.createElement(ResultBox, {
        resultText: strippedResultText,
        resultName: (0, _surveyAnswers.getResultName)(surveyResponse.components)
    }), groupedAnswerRows.map((group, index)=>/*#__PURE__*/ _react.default.createElement(ResponsesGroup, {
            key: index,
            rows: group
        })), /*#__PURE__*/ _react.default.createElement(_Footer.Footer, {
        printFacility: facility?.name,
        printedBy: currentUser?.displayName
    })));
};
const SurveyResponsesPrintout = (0, _languageContext.withLanguageContext)(SurveyResponsesPrintoutComponent);

//# sourceMappingURL=SurveyResponsesPrintout.js.map