"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MedicationAdministrationRecordDose", {
    enumerable: true,
    get: function() {
        return MedicationAdministrationRecordDose;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _model = require("../types/model");
let MedicationAdministrationRecordDose = class MedicationAdministrationRecordDose extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            doseAmount: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: false
            },
            givenTime: (0, _model.dateTimeType)('givenTime', {
                allowNull: false
            }),
            givenByUserId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            recordedByUserId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            marId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            isRemoved: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: true
            },
            doseIndex: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: false
            },
            reasonForRemoval: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            reasonForChange: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.MedicationAdministrationRecord, {
            foreignKey: 'marId',
            as: 'medicationAdministrationRecord'
        });
        this.belongsTo(models.User, {
            foreignKey: 'givenByUserId',
            as: 'givenByUser'
        });
        this.belongsTo(models.User, {
            foreignKey: 'recordedByUserId',
            as: 'recordedByUser'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=MedicationAdministrationRecordDose.js.map