"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ReportDefinition", {
    enumerable: true,
    get: function() {
        return ReportDefinition;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ReportDefinition = class ReportDefinition extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            name: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                unique: true
            },
            dbSchema: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                defaultValue: _constants.REPORT_DB_SCHEMAS.REPORTING,
                validate: {
                    isIn: [
                        Object.values(_constants.REPORT_DB_SCHEMAS)
                    ]
                }
            }
        }, {
            ...options,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'name'
                    ]
                }
            ],
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.hasMany(models.ReportDefinitionVersion, {
            as: 'versions'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ReportDefinition.js.map