"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    bulkUpsertTranslationDefaults: function() {
        return bulkUpsertTranslationDefaults;
    },
    collectTranslationData: function() {
        return collectTranslationData;
    }
});
const _lodash = require("lodash");
const _constants = require("@tamanu/constants");
const _importerEndpoint = require("./importerEndpoint");
function extractRecordName(values, dataType) {
    if (dataType === 'scheduledVaccine') return values.label;
    return values.name;
}
function collectTranslationData(model, sheetName, values) {
    const translationData = [];
    const dataType = (0, _importerEndpoint.normaliseSheetName)(sheetName, model);
    const isValidTable = model === 'ReferenceData' || (0, _lodash.camelCase)(model) === dataType;
    const isTranslatable = _constants.TRANSLATABLE_REFERENCE_TYPES.includes(dataType);
    if (isTranslatable && isValidTable) {
        translationData.push([
            `${_constants.REFERENCE_DATA_TRANSLATION_PREFIX}.${dataType}.${values.id}`,
            extractRecordName(values, dataType) ?? '',
            _constants.DEFAULT_LANGUAGE_CODE
        ]);
        // Create translations for reference data record options if they exist
        // This includes patient_field_definition options
        if (values.options && values.options.length > 0) {
            // Handle either an array or a comma-separated string of options
            const optionArray = Array.isArray(values.options) ? values.options : values.options.split(/\s*,\s*/).filter((x)=>x);
            for (const option of optionArray){
                translationData.push([
                    `${_constants.REFERENCE_DATA_TRANSLATION_PREFIX}.${dataType}.${values.id}.option.${(0, _lodash.camelCase)(option)}`,
                    option,
                    _constants.DEFAULT_LANGUAGE_CODE
                ]);
            }
        }
    }
    return translationData;
}
async function bulkUpsertTranslationDefaults(models, translationData) {
    if (translationData.length === 0) return;
    await models.TranslatedString.sequelize.query(`
      INSERT INTO translated_strings (string_id, text, language)
      VALUES ${translationData.map(()=>'(?)').join(',')}
        ON CONFLICT (string_id, language) DO UPDATE SET text = excluded.text;
    `, {
        replacements: translationData,
        type: models.TranslatedString.sequelize.QueryTypes.INSERT
    });
}

//# sourceMappingURL=translationHandler.js.map