"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Facility", {
    enumerable: true,
    get: function() {
        return Facility;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let Facility = class Facility extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            name: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            email: _sequelize.DataTypes.STRING,
            contactNumber: _sequelize.DataTypes.STRING,
            streetAddress: _sequelize.DataTypes.STRING,
            cityTown: _sequelize.DataTypes.STRING,
            division: _sequelize.DataTypes.STRING,
            type: _sequelize.DataTypes.STRING,
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                },
                {
                    unique: true,
                    fields: [
                        'name'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.hasMany(models.Department, {
            foreignKey: 'facilityId'
        });
        this.hasMany(models.Location, {
            foreignKey: 'facilityId'
        });
        this.hasMany(models.UserFacility, {
            foreignKey: 'facilityId'
        });
        this.hasMany(models.PatientBirthData, {
            foreignKey: 'birthFacilityId'
        });
        this.hasMany(models.PatientProgramRegistration, {
            foreignKey: 'registeringFacilityId'
        });
        this.hasMany(models.PatientProgramRegistration, {
            foreignKey: 'facilityId'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'catchmentId',
            as: 'catchment'
        });
        this.belongsToMany(models.User, {
            through: 'UserFacility'
        });
        this.belongsToMany(models.Patient, {
            through: 'PatientFacility',
            as: 'markedForSyncPatients'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=Facility.js.map