"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MedicationAdministrationRecordDose", {
    enumerable: true,
    get: function() {
        return MedicationAdministrationRecordDose;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _model = require("../types/model");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
let MedicationAdministrationRecordDose = class MedicationAdministrationRecordDose extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            doseAmount: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: false
            },
            givenTime: (0, _model.dateTimeType)('givenTime', {
                allowNull: false
            }),
            givenByUserId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            recordedByUserId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            marId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            isRemoved: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: true
            },
            doseIndex: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: false
            },
            reasonForRemoval: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            reasonForChange: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.MedicationAdministrationRecord, {
            foreignKey: 'marId',
            as: 'medicationAdministrationRecord'
        });
        this.belongsTo(models.User, {
            foreignKey: 'givenByUserId',
            as: 'givenByUser'
        });
        this.belongsTo(models.User, {
            foreignKey: 'recordedByUserId',
            as: 'recordedByUser'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return `
      LEFT JOIN medication_administration_records ON medication_administration_record_doses.mar_id = medication_administration_records.id
      LEFT JOIN encounter_prescriptions ON medication_administration_records.prescription_id = encounter_prescriptions.prescription_id
      LEFT JOIN encounters ON encounter_prescriptions.encounter_id = encounters.id
      LEFT JOIN patient_ongoing_prescriptions ON medication_administration_records.prescription_id = patient_ongoing_prescriptions.prescription_id
      WHERE (
        (encounters.patient_id IS NOT NULL AND encounters.patient_id IN (SELECT patient_id FROM ${markedForSyncPatientsTable}))
        OR 
        (patient_ongoing_prescriptions.patient_id IS NOT NULL AND patient_ongoing_prescriptions.patient_id IN (SELECT patient_id FROM ${markedForSyncPatientsTable}))
      )
      AND medication_administration_record_doses.updated_at_sync_tick > :since
    `;
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                patientId: 'COALESCE(encounters.patient_id, patient_ongoing_prescriptions.patient_id)'
            }),
            joins: `
        LEFT JOIN medication_administration_records ON medication_administration_record_doses.mar_id = medication_administration_records.id
        LEFT JOIN encounter_prescriptions ON medication_administration_records.prescription_id = encounter_prescriptions.prescription_id
        LEFT JOIN encounters ON encounter_prescriptions.encounter_id = encounters.id
        LEFT JOIN patient_ongoing_prescriptions ON medication_administration_records.prescription_id = patient_ongoing_prescriptions.prescription_id
      `
        };
    }
};

//# sourceMappingURL=MedicationAdministrationRecordDose.js.map