"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "templateRoutes", {
    enumerable: true,
    get: function() {
        return templateRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const templateRoutes = _express.default.Router();
const checkUniqueName = (0, _expressasynchandler.default)(async (req, res, next)=>{
    req.checkPermission('list', 'Template');
    const { id: paramId } = req.params;
    const { name, id = paramId } = req.body;
    // If we're not trying to change the name, no check needed
    if (!name) {
        next();
        return;
    }
    const conflictingRecords = await req.models.Template.count({
        where: {
            name,
            id: {
                [_sequelize.Op.ne]: id ?? null
            }
        }
    });
    if (conflictingRecords) {
        throw new _sequelize.ValidationError('Template name must be unique');
    }
    next();
});
templateRoutes.get('/$', (0, _crudHelpers.simpleGetList)('Template', null, {
    additionalFilters: {
        visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT
    }
}));
templateRoutes.post('/$', checkUniqueName, (0, _crudHelpers.simplePost)('Template'));
templateRoutes.put('/:id', checkUniqueName, (0, _crudHelpers.simplePut)('Template'));

//# sourceMappingURL=template.js.map