"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getCompletedDate: function() {
        return getCompletedDate;
    },
    getDateOfSwab: function() {
        return getDateOfSwab;
    },
    getLabMethod: function() {
        return getLabMethod;
    },
    getLaboratory: function() {
        return getLaboratory;
    },
    getRequestId: function() {
        return getRequestId;
    },
    getTimeOfSwab: function() {
        return getTimeOfSwab;
    }
});
const _getDisplayDate = require("./getDisplayDate");
const getCompletedDate = ({ completedDate }, getLocalisation)=>completedDate ? (0, _getDisplayDate.getDisplayDate)(completedDate, 'do MMM yyyy', getLocalisation) : 'Unknown';
const getDateOfSwab = ({ sampleTime })=>sampleTime ? (0, _getDisplayDate.getDisplayDate)(sampleTime, 'do MMM yyyy') : 'Unknown';
const getTimeOfSwab = ({ sampleTime })=>{
    return sampleTime ? (0, _getDisplayDate.getDisplayDate)(sampleTime, 'hh:mm a') : 'Unknown';
};
const getLaboratory = ({ laboratory }, _, getSetting)=>laboratory?.name || getSetting('templates.covidTestCertificate.laboratoryName');
const getLabMethod = ({ labTestMethod })=>(labTestMethod || {}).name || 'Unknown';
const getRequestId = ({ displayId })=>displayId || 'Unknown';

//# sourceMappingURL=labRequestAccessors.js.map