"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = {
    schema: 'fhir',
    tableName: 'practitioners'
};
async function up(query) {
    await query.dropTable(TABLE);
}
async function down(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        version_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        upstream_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        last_updated: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        identifier: {
            type: 'fhir.identifier[]',
            allowNull: false,
            defaultValue: '{}'
        },
        active: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: true
        },
        name: {
            type: 'fhir.human_name[]',
            allowNull: false,
            defaultValue: '{}'
        },
        telecom: {
            type: 'fhir.contact_point[]',
            allowNull: false,
            defaultValue: '{}'
        }
    });
    await query.addIndex(TABLE, [
        'id',
        'version_id'
    ]);
    await query.addIndex(TABLE, [
        'upstream_id'
    ]);
    await query.sequelize.query(`
    CREATE TRIGGER versioning BEFORE UPDATE ON fhir.practitioners
    FOR EACH ROW EXECUTE FUNCTION fhir.trigger_versioning()
  `);
}

//# sourceMappingURL=1668567880824-fhirDropPractitioners.js.map