"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ReferenceDrug", {
    enumerable: true,
    get: function() {
        return ReferenceDrug;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ReferenceDrug = class ReferenceDrug extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            referenceDataId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                unique: true,
                references: {
                    model: 'referenceData',
                    key: 'id'
                }
            },
            route: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            units: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            notes: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'referenceDataId',
            as: 'referenceData'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
    static getFullReferenceAssociations() {
        return [
            'referenceData'
        ];
    }
};

//# sourceMappingURL=ReferenceDrug.js.map