import { Utils } from 'sequelize';
export function buildEncounterLinkedSyncFilterJoins(tablesToTraverse) {
    return tablesToTraverse.slice(1).map((table, i)=>`
      LEFT JOIN ${table} ON ${tablesToTraverse[i]}.${Utils.singularize(table)}_id = ${table}.id
    `).join('\n');
}
export function buildEncounterLinkedSyncFilter(tablesToTraverse, markedForSyncPatientsTable) {
    const joins = buildEncounterLinkedSyncFilterJoins(tablesToTraverse);
    return `
    ${joins}
    WHERE encounters.patient_id IN (SELECT patient_id FROM ${markedForSyncPatientsTable})
    AND ${tablesToTraverse[0]}.updated_at_sync_tick > :since
  `;
}

//# sourceMappingURL=buildEncounterLinkedSyncFilter.js.map