"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "usersRouter", {
    enumerable: true,
    get: function() {
        return usersRouter;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _lodash = require("lodash");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const usersRouter = _express.default.Router();
usersRouter.get('/', (0, _expressasynchandler.default)(async (req, res)=>{
    const { store: { models: { User } }, query: { order = 'ASC', orderBy = 'displayName', rowsPerPage, page } } = req;
    req.checkPermission('list', 'User');
    const users = await User.findAll({
        include: 'facilities',
        order: [
            [
                orderBy,
                order.toUpperCase()
            ]
        ],
        limit: rowsPerPage,
        offset: page && rowsPerPage ? page * rowsPerPage : undefined
    });
    res.send({
        data: await Promise.all(users.map(async (user)=>{
            const allowedFacilities = await user.allowedFacilityIds();
            const obj = user.get({
                plain: true
            });
            return {
                ...(0, _lodash.pick)(obj, [
                    'id',
                    'displayName',
                    'email',
                    'phoneNumber',
                    'role'
                ]),
                allowedFacilities
            };
        }))
    });
}));
const VALIDATION = _yup.object().shape({
    displayName: _yup.string().required(),
    role: _yup.string().required(),
    displayId: _yup.string(),
    phoneNumber: _yup.string(),
    password: _yup.string().required(),
    email: _yup.string().email().required()
}).noUnknown();
usersRouter.post('/', (0, _expressasynchandler.default)(async (req, res)=>{
    const { store: { models: { Role, User } } } = req;
    req.checkPermission('create', 'User');
    const fields = await VALIDATION.validate(req.body);
    const role = await Role.findByPk(fields.role);
    if (!role) {
        throw new Error('Role not found');
    }
    await User.create(fields);
    res.send({
        ok: true
    });
}));

//# sourceMappingURL=users.js.map