"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    FACILITIES: function() {
        return FACILITIES;
    },
    seedFacilities: function() {
        return seedFacilities;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _utilities = require("./utilities");
const _selectFacilityIds = require("@tamanu/utils/selectFacilityIds");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const FACILITIES = (0, _utilities.splitIds)(`
  Balwyn
  Hawthorn East
  Kerang
  Lake Charm
  Marla
  Mont Albert
  National Medical
  Port Douglas
  Swan Hill
  Thornbury
  Traralgon
`);
const seedFacilities = async (models)=>{
    const facilities = FACILITIES.map((d)=>({
            ...d,
            code: d.name
        }));
    // ensure that all our configured serverFacilityIds have an entry as well
    // otherwise a bunch of tests will break
    const serverFacilityIds = (0, _selectFacilityIds.selectFacilityIds)(_config.default);
    if (serverFacilityIds) {
        serverFacilityIds.forEach((facilityId)=>{
            if (!facilities.some((x)=>x.id === facilityId)) {
                facilities.push({
                    id: facilityId,
                    name: facilityId,
                    code: facilityId
                });
            }
        });
    }
    return models.Facility.bulkCreate(facilities);
};

//# sourceMappingURL=facilities.js.map