import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
import { DataTypes } from 'sequelize';
import { buildEncounterLinkedSyncFilter, buildEncounterLinkedSyncFilterJoins } from '../sync/buildEncounterLinkedSyncFilter';
import { buildSyncLookupSelect } from '../sync/buildSyncLookupSelect';
export class LabRequestAttachment extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            // Relation can't be managed by sequelize because the
            // attachment won't get downloaded to facility server
            attachmentId: {
                type: DataTypes.STRING,
                allowNull: false
            },
            title: {
                type: DataTypes.STRING,
                allowNull: false
            },
            replacedById: {
                type: DataTypes.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.LabRequest, {
            foreignKey: 'labRequestId',
            as: 'labRequest'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable, sessionConfig) {
        if (sessionConfig.syncAllLabRequests) {
            return ''; // include all lab request attachments
        }
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'lab_requests',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await buildSyncLookupSelect(this, {
                patientId: 'encounters.patient_id',
                isLabRequestValue: 'TRUE'
            }),
            joins: buildEncounterLinkedSyncFilterJoins([
                this.tableName,
                'lab_requests',
                'encounters'
            ])
        };
    }
}

//# sourceMappingURL=LabRequestAttachment.js.map