"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    applyDefaults: function() {
        return applyDefaults;
    },
    getScopedSchema: function() {
        return getScopedSchema;
    },
    validateSettings: function() {
        return validateSettings;
    }
});
const _constants = require("@tamanu/constants");
const _global = require("./global");
const _central = require("./central");
const _facility = require("./facility");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _lodash = /*#__PURE__*/ _interop_require_wildcard(require("lodash"));
const _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const SCOPE_TO_SCHEMA = {
    [_constants.SETTINGS_SCOPES.GLOBAL]: _global.globalSettings,
    [_constants.SETTINGS_SCOPES.CENTRAL]: _central.centralSettings,
    [_constants.SETTINGS_SCOPES.FACILITY]: _facility.facilitySettings
};
const flattenSettings = (obj, parentKey = '')=>{
    return Object.entries(obj).reduce((acc, [key, value])=>{
        const fullKey = parentKey ? `${parentKey}.${key}` : key;
        if (_lodash.default.isObject(value) && !Array.isArray(value)) {
            Object.assign(acc, flattenSettings(value, fullKey));
        } else {
            acc[fullKey] = value;
        }
        return acc;
    }, {});
};
const flattenSchema = (schema, parentKey = '')=>{
    return Object.entries(schema.properties).reduce((acc, [key, value])=>{
        const fullKey = parentKey ? `${parentKey}.${key}` : key;
        if ((0, _utils.isSetting)(value)) {
            acc[fullKey] = value.type;
        } else {
            Object.assign(acc, flattenSchema(value, fullKey));
        }
        return acc;
    }, {});
};
const getScopedSchema = (scope)=>{
    return SCOPE_TO_SCHEMA[scope];
};
const validateSettings = async ({ settings, scope, schema })=>{
    const schemaValue = scope ? getScopedSchema(scope) : schema;
    if (!schemaValue) {
        throw new Error(`No schema found for scope: ${scope}`);
    }
    const flattenedSettings = flattenSettings(settings);
    const flattenedSchema = flattenSchema(schemaValue);
    const yupSchema = _yup.object().shape(flattenedSchema);
    await yupSchema.validate(flattenedSettings, {
        abortEarly: false,
        strict: true
    });
};
const applyDefaults = (settings, scope)=>{
    const schema = getScopedSchema(scope);
    const defaults = (0, _lodash.cloneDeep)((0, _utils.extractDefaults)(schema));
    return (0, _lodash.mergeWith)(defaults, settings, (_, settingValue)=>(0, _lodash.isArray)(settingValue) ? settingValue : undefined);
};

//# sourceMappingURL=validation.js.map