"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dischargeOutpatientEncounters: function() {
        return dischargeOutpatientEncounters;
    },
    getDischargeOutPatientEncountersWhereClause: function() {
        return getDischargeOutPatientEncountersWhereClause;
    }
});
const _datefns = require("date-fns");
const _sequelize = require("sequelize");
const _dateTime = require("@tamanu/utils/dateTime");
const _logging = require("../services/logging");
const _sleepAsync = require("@tamanu/utils/sleepAsync");
const getDischargeOutPatientEncountersWhereClause = ()=>{
    const today = (0, _dateTime.getCurrentDateString)();
    return {
        encounterType: 'clinic',
        endDate: null,
        startDate: {
            [_sequelize.Op.lt]: today
        }
    };
};
const dischargeOutpatientEncounters = async (models, ids, batchSize = 1000, batchSleepAsyncDurationInMilliseconds = 50)=>{
    const where = getDischargeOutPatientEncountersWhereClause();
    // If ids are passed in then we narrow down the encounters to only these ids
    if (ids && ids.length) {
        where.id = {
            [_sequelize.Op.in]: ids
        };
    }
    const oldEncountersCount = await models.Encounter.count({
        where
    });
    const batchCount = Math.ceil(oldEncountersCount / batchSize);
    _logging.log.info(`Auto-closing ${oldEncountersCount} clinic encounters in ${batchCount} batch(es) (${batchSize} records per batch)`);
    for(let i = 0; i < batchCount; i++){
        const oldEncounters = await models.Encounter.findAll({
            where,
            limit: batchSize
        });
        for (const oldEncounter of oldEncounters){
            const justBeforeMidnight = (0, _datefns.endOfDay)((0, _datefns.parseISO)(oldEncounter.startDate));
            await oldEncounter.update({
                endDate: justBeforeMidnight,
                systemNote: 'Automatically discharged',
                discharge: {
                    note: 'Automatically discharged by outpatient discharger'
                }
            });
            _logging.log.info(`Auto-closed encounter with id ${oldEncounter.id}`);
        }
        await (0, _sleepAsync.sleepAsync)(batchSleepAsyncDurationInMilliseconds);
    }
};

//# sourceMappingURL=dischargeOutpatientEncounters.js.map