"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "numeralTranslation", {
    enumerable: true,
    get: function() {
        return numeralTranslation;
    }
});
const _khmerunicodeconverter = require("khmer-unicode-converter");
const _lodash = require("lodash");
function isNumeric(value) {
    return !(0, _lodash.isNaN)(parseFloat(value));
}
const numeralTranslation = (numeral)=>{
    if (isNumeric(numeral)) return numeral;
    const latinNumerals = (0, _khmerunicodeconverter.limon)(numeral);
    if (isNumeric(latinNumerals)) return latinNumerals; // latinNumerals is always string
    return numeral;
};

//# sourceMappingURL=numeralTranslation.js.map