import React from 'react';
import { StyleSheet, View } from '@react-pdf/renderer';
import { HorizontalRule } from './HorizontalRule';
import { Row } from '../Layout';
import { Text } from '../../pdf/Text';
const styles = StyleSheet.create({
    title: {
        fontFamily: 'Helvetica-Bold',
        marginBottom: 3,
        fontSize: 11,
        fontWeight: 500
    }
});
export const DataSection = ({ title, children, hideTopRule = false, hideBottomRule = false, props })=>{
    return /*#__PURE__*/ React.createElement(View, props, /*#__PURE__*/ React.createElement(Text, {
        style: styles.title
    }, title), !hideTopRule && /*#__PURE__*/ React.createElement(HorizontalRule, null), /*#__PURE__*/ React.createElement(Row, null, children), !hideBottomRule && /*#__PURE__*/ React.createElement(HorizontalRule, null));
};

//# sourceMappingURL=DataSection.js.map