function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
import { buildPatientSyncFilterViaPatientId } from '../sync/buildPatientSyncFilterViaPatientId';
import { buildPatientLinkedLookupFilter } from '../sync/buildPatientLinkedLookupFilter';
export class PatientSecondaryId extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            value: {
                type: DataTypes.STRING,
                allowNull: false
            },
            visibilityStatus: {
                type: DataTypes.TEXT,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'typeId',
            as: 'type'
        });
    }
    static buildSyncLookupQueryDetails() {
        return buildPatientLinkedLookupFilter(this);
    }
}
_define_property(PatientSecondaryId, "buildPatientSyncFilter", buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientSecondaryId.js.map