import { type FindOptions } from 'sequelize';
import { Model } from './Model';
import type { PatientAdditionalData } from './PatientAdditionalData';
import { type InitOptions, type Models } from '../types/model';
import type { SyncHookSnapshotChanges, SyncSnapshotAttributes } from 'types/sync';
export declare class Patient extends Model {
    id: string;
    displayId: string;
    firstName?: string;
    middleName?: string;
    lastName?: string;
    culturalName?: string;
    dateOfBirth?: string;
    dateOfDeath?: string;
    sex: string;
    email?: string;
    villageId?: string;
    visibilityStatus?: string;
    mergedIntoId?: string;
    additionalData?: PatientAdditionalData[];
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getFullReferenceAssociations(): string[];
    getAdministeredVaccines(queryOptions?: {
        where?: any;
        include?: any[];
        includeNotGiven?: any;
    }): Promise<{
        count: number;
        data: any[];
    }>;
    getCovidClearanceLabTests(queryOptions: FindOptions<any> | undefined): Promise<any>;
    getCovidLabTests(queryOptions: FindOptions<any> | undefined): Promise<any>;
    getLabTestBaseIncludes(): ({
        association: string;
        include?: undefined;
        required?: undefined;
    } | {
        association: string;
        include: {
            association: string;
        }[];
        required?: undefined;
    } | {
        association: string;
        required: boolean;
        include: ({
            association: string;
            where?: undefined;
        } | {
            association: string;
            where: {
                id: string;
            };
        })[];
    })[];
    /** Patient this one was merged into (end of the chain) */
    getUltimateMergedInto(): Promise<Patient | null>;
    /** Patients this one was merged into */
    getMergedUp(): Promise<Patient[]>;
    /** Patients that were merged into this one */
    getMergedDown(): Promise<Patient[]>;
    writeFieldValues(patientFields?: {}): Promise<void>;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
    static incomingSyncHook(changes: SyncSnapshotAttributes[]): Promise<SyncHookSnapshotChanges | undefined>;
}
//# sourceMappingURL=Patient.d.ts.map