"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.OTLPMetricExporter = void 0;
const exporter_metrics_otlp_http_1 = require("@opentelemetry/exporter-metrics-otlp-http");
const otlp_grpc_exporter_base_1 = require("@opentelemetry/otlp-grpc-exporter-base");
const core_1 = require("@opentelemetry/core");
const grpc_js_1 = require("@grpc/grpc-js");
const otlp_transformer_1 = require("@opentelemetry/otlp-transformer");
const version_1 = require("./version");
const USER_AGENT = {
    'User-Agent': `OTel-OTLP-Exporter-JavaScript/${version_1.VERSION}`,
};
class OTLPMetricExporterProxy extends otlp_grpc_exporter_base_1.OTLPGRPCExporterNodeBase {
    constructor(config) {
        super(config);
        const headers = Object.assign(Object.assign(Object.assign({}, USER_AGENT), core_1.baggageUtils.parseKeyPairsIntoRecord((0, core_1.getEnv)().OTEL_EXPORTER_OTLP_METRICS_HEADERS)), config === null || config === void 0 ? void 0 : config.headers);
        this.metadata || (this.metadata = new grpc_js_1.Metadata());
        for (const [k, v] of Object.entries(headers)) {
            this.metadata.set(k, v);
        }
    }
    getServiceProtoPath() {
        return 'opentelemetry/proto/collector/metrics/v1/metrics_service.proto';
    }
    getServiceClientType() {
        return otlp_grpc_exporter_base_1.ServiceClientType.METRICS;
    }
    getDefaultUrl(config) {
        return (0, otlp_grpc_exporter_base_1.validateAndNormalizeUrl)(this.getUrlFromConfig(config));
    }
    convert(metrics) {
        return (0, otlp_transformer_1.createExportMetricsServiceRequest)(metrics);
    }
    getUrlFromConfig(config) {
        if (typeof config.url === 'string') {
            return config.url;
        }
        return ((0, core_1.getEnv)().OTEL_EXPORTER_OTLP_METRICS_ENDPOINT ||
            (0, core_1.getEnv)().OTEL_EXPORTER_OTLP_ENDPOINT ||
            otlp_grpc_exporter_base_1.DEFAULT_COLLECTOR_URL);
    }
}
/**
 * OTLP-gRPC metric exporter
 */
class OTLPMetricExporter extends exporter_metrics_otlp_http_1.OTLPMetricExporterBase {
    constructor(config) {
        super(new OTLPMetricExporterProxy(config), config);
    }
}
exports.OTLPMetricExporter = OTLPMetricExporter;
//# sourceMappingURL=OTLPMetricExporter.js.map