"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "EncounterPausePrescriptionHistory", {
    enumerable: true,
    get: function() {
        return EncounterPausePrescriptionHistory;
    }
});
const _constants = require("@tamanu/constants");
const _sequelize = require("sequelize");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _model = require("../types/model");
const _sync = require("../sync");
let EncounterPausePrescriptionHistory = class EncounterPausePrescriptionHistory extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            action: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            actionDate: (0, _model.dateTimeType)('actionDate', {
                allowNull: false
            }),
            notes: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: true
            },
            pauseDuration: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: true
            },
            pauseTimeUnit: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            tableName: 'encounter_pause_prescription_histories'
        });
    }
    static initRelations(models) {
        this.belongsTo(models.EncounterPrescription, {
            foreignKey: 'encounterPrescriptionId',
            as: 'encounterPrescription'
        });
        this.belongsTo(models.User, {
            foreignKey: 'actionUserId',
            as: 'actionUser'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounter_prescriptions',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _sync.buildEncounterPatientIdSelect)(this),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'encounter_prescriptions',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=EncounterPausePrescriptionHistory.js.map