export class Value {
    /**
     * @readonly
     */
    static readonly type: "value";
    /**
     * @param {string | number | boolean | null} value
     */
    constructor(value: string | number | boolean | null);
    /**
     * @readonly
     */
    readonly type: "value";
    /**
     * String representation of the value
     *
     * @type {string=}
     */
    representation: string | undefined;
    /**
     * The value itself
     *
     * @type {string | number | boolean | null}
     * @readonly
     */
    readonly value: string | number | boolean | null;
    /**
     * Create an identical copy of this value
     *
     * @returns {Value}
     */
    clone(): Value;
}
