"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "STEPS", {
    enumerable: true,
    get: function() {
        return STEPS;
    }
});
const _villages = /*#__PURE__*/ _interop_require_default(require("./villages"));
const _examiners = /*#__PURE__*/ _interop_require_default(require("./examiners"));
const _facilitiesDepartmentsAndLocations = /*#__PURE__*/ _interop_require_default(require("./facilitiesDepartmentsAndLocations"));
const _scheduledVaccines = /*#__PURE__*/ _interop_require_default(require("./scheduledVaccines"));
const _programSurveyAndQuestions = /*#__PURE__*/ _interop_require_default(require("./programSurveyAndQuestions"));
const _labTestCategories = /*#__PURE__*/ _interop_require_default(require("./labTestCategories"));
const _patient = /*#__PURE__*/ _interop_require_default(require("./patient"));
const _patientAdditionalData = /*#__PURE__*/ _interop_require_default(require("./patientAdditionalData"));
const _administeredVaccines = /*#__PURE__*/ _interop_require_default(require("./administeredVaccines"));
const _testsAndSurveys = /*#__PURE__*/ _interop_require_default(require("./testsAndSurveys"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const STEPS = {
    // SETUP steps may be specified as dependencies of other steps, not run directly
    SETUP: {
        villages: _villages.default,
        examiners: _examiners.default,
        facilitiesDepartmentsAndLocations: _facilitiesDepartmentsAndLocations.default,
        scheduledVaccines: _scheduledVaccines.default,
        programSurveyAndQuestions: _programSurveyAndQuestions.default,
        labTestCategories: _labTestCategories.default
    },
    // PATIENT step is special and runs before PER_PATIENT steps
    // must return a patient
    PATIENT: _patient.default,
    // PER_PATIENT steps are run after each patient is created and receive the patient's id
    PER_PATIENT: {
        patientAdditionalData: _patientAdditionalData.default,
        administeredVaccines: _administeredVaccines.default,
        testsAndSurveys: _testsAndSurveys.default
    }
};

//# sourceMappingURL=index.js.map