"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "registerPatientContactInsert", {
    enumerable: true,
    get: function() {
        return registerPatientContactInsert;
    }
});
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
const registerPatientContactInsert = (injector)=>{
    injector.websocketService.registerEvent(_constants.WS_EVENTS.PATIENT_CONTACT_INSERT, /**
     *
     * @param {Models.PatientContact} patient
     */ async (patient)=>{
        try {
            await injector.models.PatientContact.create(patient);
        } catch (e) {
            _logging.log.error('Error inserting patient contact', e);
        }
    });
};

//# sourceMappingURL=patientContactInsert.js.map