"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    // Set any incorrectly defaulted empty string start dates to the prescriptions "date" column
    await query.sequelize.query(`
    UPDATE prescriptions
    SET start_date = date
    WHERE start_date = ''
  `);
    // Remove the empty string default value
    await query.changeColumn('prescriptions', 'start_date', {
        type: _sequelize.DataTypes.DATETIMESTRING,
        allowNull: false
    });
}
async function down(query) {
    await query.changeColumn('prescriptions', 'start_date', {
        type: _sequelize.DataTypes.DATETIMESTRING,
        allowNull: false,
        defaultValue: ''
    });
}

//# sourceMappingURL=1753393877000-correctPrescriptionStartDates.js.map