import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class Prescription extends Model {
    id: string;
    isOngoing?: boolean;
    isPrn?: boolean;
    isVariableDose?: boolean;
    doseAmount: number;
    units: string;
    frequency: string;
    idealTimes?: string[];
    route: string;
    date: string;
    startDate: string;
    endDate?: string;
    durationValue?: number | null;
    durationUnit?: string | null;
    indication?: string;
    isPhoneOrder?: boolean;
    notes?: string;
    pharmacyNotes?: string;
    displayPharmacyNotesInMar?: boolean;
    quantity?: number;
    discontinued?: boolean;
    discontinuedDate?: string;
    discontinuingReason?: string;
    repeats?: number;
    prescriberId?: string;
    discontinuingClinicianId?: string;
    medicationId?: string;
    static initModel({ primaryKey, ...options }: InitOptions, models: Models): void;
    static initRelations(models: Models): void;
    static getListReferenceAssociations(): string[];
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
}
//# sourceMappingURL=Prescription.d.ts.map