"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Vitals", {
    enumerable: true,
    get: function() {
        return Vitals;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _dateTime = require("@tamanu/utils/dateTime");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _buildPatientLinkedLookupFilter = require("../sync/buildPatientLinkedLookupFilter");
const _model = require("../types/model");
const AVPU_VALUES = _constants.AVPU_OPTIONS.map((x)=>x.value);
let Vitals = class Vitals extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            dateRecorded: (0, _model.dateTimeType)('dateRecorded', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            }),
            temperature: _sequelize.DataTypes.FLOAT,
            weight: _sequelize.DataTypes.FLOAT,
            height: _sequelize.DataTypes.FLOAT,
            sbp: _sequelize.DataTypes.FLOAT,
            dbp: _sequelize.DataTypes.FLOAT,
            heartRate: _sequelize.DataTypes.FLOAT,
            respiratoryRate: _sequelize.DataTypes.FLOAT,
            spo2: _sequelize.DataTypes.FLOAT,
            avpu: _sequelize.DataTypes.ENUM(...AVPU_VALUES),
            gcs: _sequelize.DataTypes.FLOAT,
            hemoglobin: _sequelize.DataTypes.FLOAT,
            fastingBloodGlucose: _sequelize.DataTypes.FLOAT,
            urinePh: _sequelize.DataTypes.FLOAT,
            urineLeukocytes: _sequelize.DataTypes.STRING,
            urineNitrites: _sequelize.DataTypes.STRING,
            urobilinogen: _sequelize.DataTypes.FLOAT,
            urineProtein: _sequelize.DataTypes.STRING,
            bloodInUrine: _sequelize.DataTypes.STRING,
            urineSpecificGravity: _sequelize.DataTypes.FLOAT,
            urineKetone: _sequelize.DataTypes.STRING,
            urineBilirubin: _sequelize.DataTypes.STRING,
            urineGlucose: _sequelize.DataTypes.FLOAT
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            validate: {
                mustHaveEncounter () {
                    if (!this.encounterId) {
                        throw new Error('A vitals reading must be attached to an encounter.');
                    }
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildPatientLinkedLookupFilter.buildEncounterPatientIdSelect)(this),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=Vitals.js.map