"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    findAdministrationTimeSlotFromIdealTime: function() {
        return findAdministrationTimeSlotFromIdealTime;
    },
    getDateFromTimeString: function() {
        return getDateFromTimeString;
    },
    getDose: function() {
        return getDose;
    },
    getFirstAdministrationDate: function() {
        return getFirstAdministrationDate;
    },
    getTranslatedFrequency: function() {
        return getTranslatedFrequency;
    }
});
const _datefns = require("date-fns");
const _constants = require("@tamanu/constants");
const _lodash = require("lodash");
const findAdministrationTimeSlotFromIdealTime = (idealTime)=>{
    const index = _constants.MEDICATION_ADMINISTRATION_TIME_SLOTS.findIndex((slot)=>{
        const startDate = getDateFromTimeString(slot.startTime).getTime();
        const endDate = getDateFromTimeString(slot.endTime).getTime();
        const idealDate = getDateFromTimeString(idealTime).getTime();
        return idealDate >= startDate && idealDate < endDate && idealDate - startDate < endDate - startDate;
    });
    const timeSlot = _constants.MEDICATION_ADMINISTRATION_TIME_SLOTS[index];
    return {
        index,
        timeSlot,
        value: idealTime
    };
};
const getDateFromTimeString = (time, initialDate = new Date())=>{
    if (typeof time !== 'string' || !time?.includes?.(':')) {
        time = (0, _datefns.format)(new Date(time), 'HH:mm');
    }
    const parsedTime = time.split(':');
    const hour = parseInt(parsedTime[0]);
    const minute = parseInt(parsedTime[1]) || 0;
    return (0, _datefns.set)(initialDate, {
        hours: hour,
        minutes: minute,
        seconds: 0
    });
};
const getFirstAdministrationDate = (startDate, idealTimes)=>{
    const firstStartTime = idealTimes.map((idealTime)=>getDateFromTimeString(idealTime, startDate)).concat(idealTimes.map((idealTime)=>getDateFromTimeString(idealTime, (0, _datefns.addDays)(startDate, 1)))).filter((idealTime)=>idealTime.getTime() > startDate.getTime()).sort((a, b)=>a - b)[0];
    return firstStartTime;
};
const getDose = (medication, getTranslation, getEnumTranslation)=>{
    let { doseAmount, units, isVariableDose } = medication;
    if (!units) return '';
    if (isVariableDose) doseAmount = getTranslation('medication.table.variable', 'Variable');
    return `${doseAmount} ${getEnumTranslation(_constants.DRUG_UNIT_SHORT_LABELS, units)}`;
};
const getTranslatedFrequency = (frequency, getTranslation)=>{
    return getTranslation(`medication.frequency.${(0, _lodash.camelCase)(frequency)}.label`, frequency);
};

//# sourceMappingURL=medication.js.map