"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "attachChangelogToSnapshotRecords", {
    enumerable: true,
    get: function() {
        return attachChangelogToSnapshotRecords;
    }
});
const _sequelize = require("sequelize");
const attachChangelogToSnapshotRecords = async ({ models, sequelize }, snapshotRecords, { minSourceTick, maxSourceTick })=>{
    if (!snapshotRecords.length) {
        return snapshotRecords;
    }
    const changelogRecords = await sequelize.query(`
   SELECT * FROM logs.changes
    WHERE updated_at_sync_tick >= :minSourceTick
    ${maxSourceTick ? 'AND updated_at_sync_tick <= :maxSourceTick' : ''}
    AND (table_name || '-' || record_id) IN (:recordTypeAndIds)
    `, {
        model: models.ChangeLog,
        type: _sequelize.QueryTypes.SELECT,
        mapToModel: true,
        replacements: {
            minSourceTick,
            maxSourceTick,
            recordTypeAndIds: snapshotRecords.map(({ recordType, recordId })=>`${recordType}-${recordId}`)
        }
    });
    const changelogRecordsByRecordId = changelogRecords.reduce((acc, changelogRecord)=>{
        const id = `${changelogRecord.tableName}-${changelogRecord.recordId}`;
        (acc[id] = acc[id] || []).push(changelogRecord);
        return acc;
    }, {});
    snapshotRecords.forEach((snapshotRecord)=>{
        const id = `${snapshotRecord.recordType}-${snapshotRecord.recordId}`;
        snapshotRecord.changelogRecords = changelogRecordsByRecordId[id] || [];
    });
    return snapshotRecords;
};

//# sourceMappingURL=attachChangelogToSnapshotRecords.js.map