import React from 'react';
import PropTypes from 'prop-types';
import { Document, StyleSheet, View } from '@react-pdf/renderer';
import { PatientDetailsWithBarcode } from './printComponents/PatientDetailsWithBarcode';
import { styles, CertificateContent, CertificateHeader, Col, Row, Signature } from './Layout';
import { LetterheadSection } from './LetterheadSection';
import { P } from './Typography';
import { DataItem } from './printComponents/DataItem';
import { PrintableBarcode } from './printComponents/PrintableBarcode';
import { HorizontalRule } from './printComponents/HorizontalRule';
import { EncounterDetails } from './printComponents/EncounterDetails';
import { getDisplayDate } from './getDisplayDate';
import { DoubleHorizontalRule } from './printComponents/DoubleHorizontalRule';
import { withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
import { Text } from '../pdf/Text';
const DATE_TIME_FORMAT = 'dd/MM/yyyy h:mma';
const headingFontSize = 11;
const textFontSize = 9;
const signingSectionStyles = StyleSheet.create({
    underlinedText: {
        textDecoration: 'underline'
    },
    signatureView: {
        paddingRight: 32
    },
    disclaimerText: {
        fontStyle: 'italic',
        fontSize: 8
    }
});
const labDetailsSectionStyles = StyleSheet.create({
    barcodeLabelText: {
        marginTop: 9
    },
    divider: {
        borderBottom: '2px solid black',
        marginVertical: '10px'
    },
    detailsContainer: {
        marginBottom: 5
    }
});
const generalStyles = StyleSheet.create({
    container: {
        marginVertical: 6
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: generalStyles.container,
        ...props
    });
const LabRequestSigningSection = ({ getTranslation })=>{
    const BaseSigningSection = ({ title })=>/*#__PURE__*/ React.createElement(View, {
            style: {
                flexDirection: 'column'
            }
        }, /*#__PURE__*/ React.createElement(P, {
            bold: true,
            style: signingSectionStyles.underlinedText,
            fontSize: 9
        }, title), /*#__PURE__*/ React.createElement(View, {
            style: signingSectionStyles.signatureView
        }, /*#__PURE__*/ React.createElement(Signature, {
            text: "Signed",
            fontSize: textFontSize,
            lineThickness: 0.5
        }), /*#__PURE__*/ React.createElement(Signature, {
            text: "Date",
            fontSize: textFontSize,
            lineThickness: 0.5
        })));
    return /*#__PURE__*/ React.createElement(View, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(BaseSigningSection, {
        title: getTranslation('general.localisedField.clinician.label', 'Clinician')
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(BaseSigningSection, {
        title: "Patient"
    }), /*#__PURE__*/ React.createElement(Text, {
        style: signingSectionStyles.disclaimerText
    }, "Patient to sign if required, according to local regulations"))));
};
const LabRequestDetailsView = ({ labRequests })=>{
    const labTestTypeAccessor = ({ labTestPanelRequest, tests })=>{
        if (labTestPanelRequest) {
            return labTestPanelRequest.labTestPanel.name;
        }
        return tests?.map((test)=>test.labTestType?.name).join(', ') || '';
    };
    const notesAccessor = ({ notes })=>{
        return notes?.map((note)=>note?.content || '').filter(Boolean).join(',\n') || '';
    };
    return /*#__PURE__*/ React.createElement(View, null, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        fontSize: headingFontSize,
        mb: 3
    }, "Lab request details"), /*#__PURE__*/ React.createElement(HorizontalRule, null), labRequests.map((request, index)=>{
        return /*#__PURE__*/ React.createElement(View, {
            key: request.id,
            style: labDetailsSectionStyles.detailsContainer
        }, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
            label: "Request ID",
            value: request.displayId
        }), /*#__PURE__*/ React.createElement(DataItem, {
            label: "Priority",
            value: request.priority?.name
        }), /*#__PURE__*/ React.createElement(DataItem, {
            label: "Requested date & time",
            value: getDisplayDate(request.requestedDate, DATE_TIME_FORMAT)
        }), /*#__PURE__*/ React.createElement(DataItem, {
            label: "Requested by",
            value: request.requestedBy?.displayName
        }), /*#__PURE__*/ React.createElement(DataItem, {
            label: "Test category",
            value: request.category?.name
        }), /*#__PURE__*/ React.createElement(DataItem, {
            label: "Tests",
            value: labTestTypeAccessor(request)
        })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(P, {
            style: labDetailsSectionStyles.barcodeLabelText,
            fontSize: textFontSize,
            bold: true
        }, "Request ID barcode:"), /*#__PURE__*/ React.createElement(PrintableBarcode, {
            id: request.displayId
        })))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(DataItem, {
            label: "Notes",
            value: notesAccessor(request)
        })), /*#__PURE__*/ React.createElement(HorizontalRule, null), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
            label: "Sample date & time",
            value: getDisplayDate(request.sampleTime, DATE_TIME_FORMAT)
        }), /*#__PURE__*/ React.createElement(DataItem, {
            label: "Collected by",
            value: request.collectedBy?.displayName
        })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
            label: "Site",
            value: request.site?.name
        }), /*#__PURE__*/ React.createElement(DataItem, {
            label: "Specimen type",
            value: request.specimenType?.name
        }))), index < labRequests.length - 1 && /*#__PURE__*/ React.createElement(View, {
            style: labDetailsSectionStyles.divider
        }));
    }), /*#__PURE__*/ React.createElement(DoubleHorizontalRule, null));
};
const MultipleLabRequestsPrintoutComponent = /*#__PURE__*/ React.memo(({ patientData, labRequests, encounter, certificateData, getLocalisation, getTranslation })=>{
    const { logo } = certificateData;
    return /*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: styles.page
    }, /*#__PURE__*/ React.createElement(CertificateHeader, null, /*#__PURE__*/ React.createElement(LetterheadSection, {
        logoSrc: logo,
        letterheadConfig: certificateData,
        certificateTitle: "Lab request"
    }), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(PatientDetailsWithBarcode, {
        patient: patientData,
        getLocalisation: getLocalisation
    })), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(EncounterDetails, {
        encounter: encounter
    }))), /*#__PURE__*/ React.createElement(CertificateContent, null, /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(LabRequestDetailsView, {
        labRequests: labRequests
    })), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(LabRequestSigningSection, {
        getTranslation: getTranslation,
        labRequests: labRequests
    })))));
});
export const MultipleLabRequestsPrintout = withLanguageContext(MultipleLabRequestsPrintoutComponent);
MultipleLabRequestsPrintout.propTypes = {
    patientData: PropTypes.object.isRequired,
    village: PropTypes.object.isRequired,
    encounter: PropTypes.object.isRequired,
    labRequests: PropTypes.array.isRequired,
    certificateData: PropTypes.object.isRequired
};

//# sourceMappingURL=MultipleLabRequestsPrintout.js.map