export declare const DRUG_ROUTES: {
    dermal: string;
    ear: string;
    eye: string;
    intramuscular: string;
    intravenous: string;
    inhaled: string;
    nasal: string;
    oral: string;
    rectal: string;
    subcutaneous: string;
    sublingual: string;
    topical: string;
    vaginal: string;
};
export declare const DRUG_ROUTE_VALUES: string[];
export declare const DRUG_ROUTE_LABELS: {
    [x: string]: string;
};
export declare const DRUG_UNITS: {
    percentage: string;
    capsule: string;
    disc: string;
    douche: string;
    drop: string;
    ffu: string;
    g: string;
    iu: string;
    l: string;
    lozenge: string;
    mg: string;
    mcg: string;
    ml: string;
    mmol: string;
    mol: string;
    patch: string;
    pellet: string;
    pouch: string;
    puff: string;
    ring: string;
    smear: string;
    spray: string;
    stick: string;
    strip: string;
    suppository: string;
    swab: string;
    tablet: string;
    tbsp: string;
    tsp: string;
    u: string;
    vial: string;
    wafer: string;
};
export declare const DRUG_UNIT_VALUES: string[];
export declare const DRUG_UNIT_LABELS: any;
export declare const DRUG_UNIT_SHORT_LABELS: {
    [x: string]: string;
};
export declare const REPEATS_LABELS: number[];
export declare const ADMINISTRATION_FREQUENCIES: {
    DAILY_IN_THE_MORNING: string;
    DAILY_AT_MIDDAY: string;
    DAILY_AT_NIGHT: string;
    DAILY: string;
    TWO_TIMES_DAILY: string;
    THREE_TIMES_DAILY: string;
    FOUR_TIMES_DAILY: string;
    EVERY_4_HOURS: string;
    EVERY_6_HOURS: string;
    EVERY_8_HOURS: string;
    EVERY_SECOND_DAY: string;
    ONCE_A_WEEK: string;
    ONCE_A_MONTH: string;
    IMMEDIATELY: string;
    AS_DIRECTED: string;
    TWICE_DAILY_AM_AND_MIDDAY: string;
};
export declare const ADMINISTRATION_FREQUENCY_SYNONYMS: {
    [x: string]: string[];
};
export declare const ADMINISTRATION_FREQUENCY_DETAILS: {
    [x: string]: {
        startTimes: string[];
        dosesPerDay: number;
    } | {
        startTimes: null;
        dosesPerDay: null;
    };
};
export declare const MEDICATION_DURATION_UNITS: {
    [key: string]: keyof Duration;
};
export declare const MEDICATION_DURATION_DISPLAY_UNITS_LABELS: {
    [x: string]: string;
};
export declare const MEDICATION_DURATION_UNITS_LABELS: {
    [x: string]: string;
};
export declare const MEDICATION_PAUSE_DURATION_UNITS_LABELS: {
    [x: string]: string;
};
export declare const ADMINISTRATION_STATUS: {
    GIVEN: string;
    NOT_GIVEN: string;
};
export declare const ADMINISTRATION_STATUS_LABELS: {
    [x: string]: string;
};
export declare const MEDICATION_ADMINISTRATION_TIME_SLOTS: ({
    startTime: string;
    endTime: string;
    periodLabel?: undefined;
} | {
    startTime: string;
    endTime: string;
    periodLabel: string;
})[];
//# sourceMappingURL=medications.d.ts.map