"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query('ALTER TABLE settings DROP CONSTRAINT settings_alive_key_unique_cnt');
    await query.addConstraint('settings', {
        name: 'settings_alive_key_unique_cnt',
        fields: [
            'key',
            'facility_id'
        ],
        type: 'UNIQUE'
    });
}
async function down(query) {
    await query.sequelize.query('ALTER TABLE settings DROP CONSTRAINT settings_alive_key_unique_cnt');
    await query.addConstraint('settings', {
        name: 'settings_alive_key_unique_cnt',
        fields: [
            'key',
            'facility_id',
            'deleted_at'
        ],
        type: 'UNIQUE'
    });
}

//# sourceMappingURL=1728609178353-updateSettingsUniqueIndex.js.map