import { DataTypes } from 'sequelize';
export async function up(query) {
    // Set any incorrectly defaulted empty string start dates to the prescriptions "date" column
    await query.sequelize.query(`
    UPDATE prescriptions
    SET start_date = date
    WHERE start_date = ''
  `);
    // Remove the empty string default value
    await query.changeColumn('prescriptions', 'start_date', {
        type: DataTypes.DATETIMESTRING,
        allowNull: false
    });
}
export async function down(query) {
    await query.changeColumn('prescriptions', 'start_date', {
        type: DataTypes.DATETIMESTRING,
        allowNull: false,
        defaultValue: ''
    });
}

//# sourceMappingURL=1753393877000-correctPrescriptionStartDates.js.map