"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "upgradeCommand", {
    enumerable: true,
    get: function() {
        return upgradeCommand;
    }
});
const _commander = require("commander");
const _upgrade = require("@tamanu/upgrade");
const _database = require("../database");
const _versionCompatibility = require("../middleware/versionCompatibility");
const upgradeCommand = new _commander.Command('upgrade').alias('migrate').description('Upgrade Tamanu installation').action(async ()=>{
    const { sequelize, models } = await (0, _database.initDatabase)();
    try {
        await (0, _upgrade.upgrade)({
            sequelize,
            models,
            toVersion: _versionCompatibility.VERSION,
            serverType: 'facility'
        });
        process.exit(0);
    } catch (err) {
        console.error(err);
        process.exit(1);
    }
});

//# sourceMappingURL=upgrade.js.map