"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('appointment_schedules', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        until_date: {
            type: _sequelize.DataTypes.DATESTRING,
            allowNull: true
        },
        interval: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: false
        },
        frequency: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        days_of_week: {
            type: _sequelize.DataTypes.ARRAY(_sequelize.DataTypes.STRING),
            allowNull: true
        },
        nth_weekday: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: true
        },
        occurrence_count: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('NOW')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('NOW')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.addColumn('appointments', 'schedule_id', {
        type: _sequelize.DataTypes.UUID,
        allowNull: true,
        references: {
            model: 'appointment_schedules',
            key: 'id'
        }
    });
    await query.addIndex('appointments', [
        'schedule_id'
    ]);
}
async function down(query) {
    await query.removeIndex('appointments', [
        'schedule_id'
    ]);
    await query.removeColumn('appointments', 'schedule_id');
    await query.dropTable('appointment_schedules', {});
}

//# sourceMappingURL=1733444238689-createAppointmentSchedulesTable.js.map