import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
export class ReferenceDrug extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            referenceDataId: {
                type: DataTypes.STRING,
                allowNull: false,
                unique: true,
                references: {
                    model: 'referenceData',
                    key: 'id'
                }
            },
            route: {
                type: DataTypes.STRING,
                allowNull: true
            },
            units: {
                type: DataTypes.STRING,
                allowNull: true
            },
            notes: {
                type: DataTypes.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'referenceDataId',
            as: 'referenceData'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
    static getFullReferenceAssociations() {
        return [
            'referenceData'
        ];
    }
}

//# sourceMappingURL=ReferenceDrug.js.map