"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const _chance = require("../../chance");
const _constants = require("../constants");
const _default = {
    run: async (store)=>{
        const { ReferenceData } = store.models;
        const villages = [];
        for(let i = 0; i < _constants.NUM_VILLAGES; i++){
            const name = _chance.chance.city();
            const code = name.toLowerCase();
            const id = `${_constants.REF_ID_PREFIX}-village-${i}`;
            const village = await ReferenceData.upsert({
                id,
                code,
                name,
                type: 'village'
            }, {
                returning: true
            });
            villages.push(village);
        }
        return villages;
    }
};

//# sourceMappingURL=villages.js.map