"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    // Set any incorrectly defaulted empty string start dates to the prescriptions "date" column
    await query.sequelize.query(`
    UPDATE prescriptions
    SET start_date = date
    WHERE start_date = ''
  `);
    // Remove the empty string default value
    await query.sequelize.query(`
    ALTER TABLE prescriptions 
    ALTER COLUMN start_date DROP DEFAULT
  `);
}
async function down(query) {
    await query.sequelize.query(`
    ALTER TABLE prescriptions 
    ALTER COLUMN start_date SET DEFAULT ''
  `);
}

//# sourceMappingURL=1753393877000-correctPrescriptionStartDates.js.map