import { DataTypes } from 'sequelize';
import { LAB_REQUEST_STATUSES, SYNC_DIRECTIONS } from '@tamanu/constants';
import { buildEncounterLinkedSyncFilter, buildEncounterLinkedSyncFilterJoins } from '../sync/buildEncounterLinkedSyncFilter';
import { Model } from './Model';
import { buildSyncLookupSelect } from '../sync/buildSyncLookupSelect';
const LAB_REQUEST_STATUS_VALUES = Object.values(LAB_REQUEST_STATUSES);
/** Holds a record of a lab request's status at a specific point in time */ export class LabRequestLog extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            status: DataTypes.ENUM(...LAB_REQUEST_STATUS_VALUES)
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.LabRequest, {
            foreignKey: 'labRequestId',
            as: 'labRequest'
        });
        this.belongsTo(models.User, {
            foreignKey: 'updatedById',
            as: 'updatedBy'
        });
    }
    static getListReferenceAssociations() {
        return [
            'labRequest',
            'updatedBy'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'lab_requests',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await buildSyncLookupSelect(this, {
                patientId: 'encounters.patient_id',
                isLabRequestValue: 'TRUE'
            }),
            joins: buildEncounterLinkedSyncFilterJoins([
                this.tableName,
                'lab_requests',
                'encounters'
            ])
        };
    }
}

//# sourceMappingURL=LabRequestLog.js.map