"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MultipleLabRequestsPrintout", {
    enumerable: true,
    get: function() {
        return MultipleLabRequestsPrintout;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _proptypes = /*#__PURE__*/ _interop_require_default(require("prop-types"));
const _renderer = require("@react-pdf/renderer");
const _PatientDetailsWithBarcode = require("./printComponents/PatientDetailsWithBarcode");
const _Layout = require("./Layout");
const _LetterheadSection = require("./LetterheadSection");
const _Typography = require("./Typography");
const _DataItem = require("./printComponents/DataItem");
const _PrintableBarcode = require("./printComponents/PrintableBarcode");
const _HorizontalRule = require("./printComponents/HorizontalRule");
const _EncounterDetails = require("./printComponents/EncounterDetails");
const _getDisplayDate = require("./getDisplayDate");
const _DoubleHorizontalRule = require("./printComponents/DoubleHorizontalRule");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const DATE_TIME_FORMAT = 'dd/MM/yyyy h:mma';
const headingFontSize = 11;
const textFontSize = 9;
const signingSectionStyles = _renderer.StyleSheet.create({
    underlinedText: {
        textDecoration: 'underline'
    },
    signatureView: {
        paddingRight: 32
    },
    disclaimerText: {
        fontStyle: 'italic',
        fontSize: 8
    }
});
const labDetailsSectionStyles = _renderer.StyleSheet.create({
    barcodeLabelText: {
        marginTop: 9
    },
    divider: {
        borderBottom: '2px solid black',
        marginVertical: '10px'
    },
    detailsContainer: {
        marginBottom: 5
    }
});
const generalStyles = _renderer.StyleSheet.create({
    container: {
        marginVertical: 6
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.container,
        ...props
    });
const LabRequestSigningSection = ({ getTranslation })=>{
    const BaseSigningSection = ({ title })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: {
                flexDirection: 'column'
            }
        }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
            bold: true,
            style: signingSectionStyles.underlinedText,
            fontSize: 9
        }, title), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: signingSectionStyles.signatureView
        }, /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
            text: "Signed",
            fontSize: textFontSize,
            lineThickness: 0.5
        }), /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
            text: "Date",
            fontSize: textFontSize,
            lineThickness: 0.5
        })));
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(BaseSigningSection, {
        title: getTranslation('general.localisedField.clinician.label', 'Clinician')
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(BaseSigningSection, {
        title: "Patient"
    }), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: signingSectionStyles.disclaimerText
    }, "Patient to sign if required, according to local regulations"))));
};
const LabRequestDetailsView = ({ labRequests })=>{
    const labTestTypeAccessor = ({ labTestPanelRequest, tests })=>{
        if (labTestPanelRequest) {
            return labTestPanelRequest.labTestPanel.name;
        }
        return tests?.map((test)=>test.labTestType?.name).join(', ') || '';
    };
    const notesAccessor = ({ notes })=>{
        return notes?.map((note)=>note?.content || '').filter(Boolean).join(',\n') || '';
    };
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        bold: true,
        fontSize: headingFontSize,
        mb: 3
    }, "Lab request details"), /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, null), labRequests.map((request, index)=>{
        return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            key: request.id,
            style: labDetailsSectionStyles.detailsContainer
        }, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Request ID",
            value: request.displayId
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Priority",
            value: request.priority?.name
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Requested date & time",
            value: (0, _getDisplayDate.getDisplayDate)(request.requestedDate, DATE_TIME_FORMAT)
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Requested by",
            value: request.requestedBy?.displayName
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Test category",
            value: request.category?.name
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Tests",
            value: labTestTypeAccessor(request)
        })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
            style: labDetailsSectionStyles.barcodeLabelText,
            fontSize: textFontSize,
            bold: true
        }, "Request ID barcode:"), /*#__PURE__*/ _react.default.createElement(_PrintableBarcode.PrintableBarcode, {
            id: request.displayId
        })))), /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Notes",
            value: notesAccessor(request)
        })), /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, null), /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Sample date & time",
            value: (0, _getDisplayDate.getDisplayDate)(request.sampleTime, DATE_TIME_FORMAT)
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Collected by",
            value: request.collectedBy?.displayName
        })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Site",
            value: request.site?.name
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Specimen type",
            value: request.specimenType?.name
        }))), index < labRequests.length - 1 && /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: labDetailsSectionStyles.divider
        }));
    }), /*#__PURE__*/ _react.default.createElement(_DoubleHorizontalRule.DoubleHorizontalRule, null));
};
const MultipleLabRequestsPrintoutComponent = /*#__PURE__*/ _react.default.memo(({ patientData, labRequests, encounter, certificateData, getLocalisation, getTranslation })=>{
    const { logo } = certificateData;
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: _Layout.styles.page
    }, /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logo,
        letterheadConfig: certificateData,
        certificateTitle: "Lab request"
    }), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_PatientDetailsWithBarcode.PatientDetailsWithBarcode, {
        patient: patientData,
        getLocalisation: getLocalisation
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_EncounterDetails.EncounterDetails, {
        encounter: encounter
    }))), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateContent, null, /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(LabRequestDetailsView, {
        labRequests: labRequests
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(LabRequestSigningSection, {
        getTranslation: getTranslation,
        labRequests: labRequests
    })))));
});
const MultipleLabRequestsPrintout = (0, _languageContext.withLanguageContext)(MultipleLabRequestsPrintoutComponent);
MultipleLabRequestsPrintout.propTypes = {
    patientData: _proptypes.default.object.isRequired,
    village: _proptypes.default.object.isRequired,
    encounter: _proptypes.default.object.isRequired,
    labRequests: _proptypes.default.array.isRequired,
    certificateData: _proptypes.default.object.isRequired
};

//# sourceMappingURL=MultipleLabRequestsPrintout.js.map