/* eslint-disable no-undef */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    useLanguageContext: function() {
        return useLanguageContext;
    },
    withLanguageContext: function() {
        return withLanguageContext;
    }
});
const _react = /*#__PURE__*/ _interop_require_wildcard(require("react"));
const _lodash = require("lodash");
const _translationFactory = require("../translation/translationFactory");
const _enumRegistry = require("@tamanu/shared/utils/enumRegistry");
const _registerFonts = require("./registerFonts");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
(0, _registerFonts.registerFonts)();
const LanguageContext = /*#__PURE__*/ (0, _react.createContext)({});
const useLanguageContext = ()=>{
    const ctx = (0, _react.useContext)(LanguageContext);
    return ctx;
};
const withLanguageContext = (Component)=>(props)=>{
        const context = useLanguageContext();
        const { translations, settings, ...other } = props;
        // If in the pdf.worker context we pass settings an an object not as a function
        // and should build a getSetting function from it.
        let { getSetting } = other;
        if (!getSetting && settings) {
            getSetting = (key)=>(0, _lodash.get)(settings, key);
        }
        const isGlobalFontEnabled = getSetting('features.useGlobalPdfFont');
        const pdfFont = isGlobalFontEnabled ? 'GlobalPdfFont' : 'Helvetica';
        const pdfFontBold = isGlobalFontEnabled ? 'GlobalPdfFont-Bold' : 'Helvetica-Bold';
        const contextValue = (0, _react.useMemo)(()=>{
            return {
                makeIntlStyleSheet (style) {
                    if (typeof style !== 'object') return {};
                    return (0, _lodash.cloneDeep)(style);
                },
                getTranslation (stringId, fallback, translationOptions) {
                    const translationFunc = (0, _translationFactory.translationFactory)(translations);
                    const { value } = translationFunc(stringId, fallback, translationOptions);
                    return value;
                },
                getEnumTranslation (enumValues, currentValue) {
                    const translationFunc = (0, _translationFactory.translationFactory)(translations);
                    const fallback = enumValues[currentValue];
                    const stringId = `${(0, _enumRegistry.getEnumPrefix)(enumValues)}.${currentValue}`;
                    const { value } = translationFunc(stringId, fallback);
                    return value;
                },
                pdfFont,
                pdfFontBold
            };
        }, [
            translations,
            pdfFont,
            pdfFontBold
        ]);
        // unsure that we are using only one provider for the component tree
        return 'makeIntlStyleSheet' in context ? /*#__PURE__*/ _react.default.createElement(Component, {
            ...other,
            getSetting: getSetting
        }) : /*#__PURE__*/ _react.default.createElement(LanguageContext.Provider, {
            value: contextValue
        }, /*#__PURE__*/ _react.default.createElement(Component, {
            ...other,
            getSetting: getSetting
        }));
    };

//# sourceMappingURL=languageContext.js.map