"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
const _sequelize = require("sequelize");
const TABLE = {
    schema: 'logs',
    tableName: 'migrations'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        logged_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('adjusted_timestamp')
        },
        record_sync_tick: {
            type: _sequelize.DataTypes.BIGINT,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.cast(_sequelize.Sequelize.fn('local_system_fact', _constants.FACT_CURRENT_SYNC_TICK, '0'), 'bigint')
        },
        device_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('local_system_fact', _constants.FACT_DEVICE_ID, 'unknown')
        },
        version: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('local_system_fact', _constants.FACT_CURRENT_VERSION, 'unknown')
        },
        direction: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        migrations: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: false
        }
    });
    await query.addIndex(TABLE, [
        'logged_at'
    ], {
        using: 'btree'
    });
    await query.addIndex(TABLE, [
        'record_sync_tick'
    ], {
        using: 'btree'
    });
    await query.addIndex(TABLE, [
        'version'
    ], {
        using: 'btree'
    });
    await query.addIndex(TABLE, [
        'device_id'
    ], {
        using: 'hash'
    });
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1741215641836-createMigrationLogsTable.js.map