import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
export class UserPreference extends Model {
    static initModel(options) {
        super.init({
            id: {
                type: `TEXT GENERATED ALWAYS AS ("user_id" || ';' || "key" || ';' || COALESCE("facility_id", '')) STORED`,
                primaryKey: true,
                set () {
                // any sets of the convenience generated "id" field can be ignored
                }
            },
            key: {
                type: DataTypes.STRING,
                allowNull: false
            },
            value: {
                type: DataTypes.JSONB,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static async getAllPreferences(userId, facilityId) {
        const generalUserPreferences = await UserPreference.findAll({
            where: {
                userId,
                facilityId: null
            }
        });
        const facilityUserPreferences = await UserPreference.findAll({
            where: {
                userId,
                facilityId
            }
        });
        const allPreferences = {};
        for (const userPreference of generalUserPreferences){
            allPreferences[userPreference.key] = userPreference.value;
        }
        for (const userPreference of facilityUserPreferences){
            allPreferences[userPreference.key] = userPreference.value;
        }
        return allPreferences;
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
        this.belongsTo(models.Facility, {
            foreignKey: 'facilityId',
            as: 'facility'
        });
    }
    static buildSyncFilter() {
        return null;
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
}

//# sourceMappingURL=UserPreference.js.map