import { StyleSheet, View, Text } from '@react-pdf/renderer';
import React from 'react';
import { flatten } from '../../pdf/flattenStyles';
import { useLanguageContext } from '../../pdf/languageContext';
const styles = StyleSheet.create({
    header: {
        flexDirection: 'row',
        display: 'flex',
        alignSelf: 'flex-end',
        marginBottom: 20
    },
    labelText: {
        fontSize: 8,
        fontWeight: 700,
        color: '#888888'
    },
    valueText: {
        fontSize: 8,
        fontWeight: 400,
        color: '#888888'
    }
});
export const useTextStyles = (styles)=>{
    const { makeIntlStyleSheet } = useLanguageContext();
    const mergedStyle = flatten(styles);
    return makeIntlStyleSheet(mergedStyle);
};
export const MultiPageHeader = ({ documentName, documentSubname, patientName, patientId })=>{
    const { getTranslation } = useLanguageContext();
    const valueStyles = useTextStyles(styles.valueText);
    const labelStyles = useTextStyles(styles.labelText);
    const ValueText = (props)=>/*#__PURE__*/ React.createElement(Text, {
            bold: true,
            style: valueStyles,
            ...props
        });
    const LabelText = (props)=>/*#__PURE__*/ React.createElement(Text, {
            style: labelStyles,
            ...props
        });
    const HeaderContent = ()=>/*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(LabelText, null, `${documentName} `), documentSubname && /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(ValueText, null, "|"), /*#__PURE__*/ React.createElement(LabelText, null, " ", documentSubname, " ")), /*#__PURE__*/ React.createElement(ValueText, null, "|"), /*#__PURE__*/ React.createElement(LabelText, null, " ", getTranslation('general.patientName.label', 'Patient name')), /*#__PURE__*/ React.createElement(ValueText, null, ": ", patientName, " "), /*#__PURE__*/ React.createElement(ValueText, null, "|"), /*#__PURE__*/ React.createElement(LabelText, null, " ", getTranslation('general.patientId.label', 'Patient ID')), /*#__PURE__*/ React.createElement(ValueText, null, ": ", patientId));
    return /*#__PURE__*/ React.createElement(View, {
        style: styles.header,
        render: ({ pageNumber })=>pageNumber > 1 && /*#__PURE__*/ React.createElement(HeaderContent, null),
        fixed: true
    });
};

//# sourceMappingURL=MultiPageHeader.js.map