import { type CreateOptions } from 'sequelize';
import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
import { buildPatientSyncFilterViaPatientId } from '../sync';
declare const NOTIFICATION_TYPE_VALUES: string[];
declare const NOTIFICATION_STATUS_VALUES: string[];
export declare class Notification extends Model {
    id: string;
    type: (typeof NOTIFICATION_TYPE_VALUES)[number];
    status: (typeof NOTIFICATION_STATUS_VALUES)[number];
    createdTime?: string;
    metadata: Record<string, any>;
    userId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter: typeof buildPatientSyncFilterViaPatientId;
    static buildSyncLookupQueryDetails(): {
        select: string;
    };
    static getFullReferenceAssociations(): ({
        model: typeof import("./User").User;
        as: string;
        attributes: string[];
    } | {
        model: typeof import("./Patient").Patient;
        as: string;
        attributes: string[];
    })[];
    static pushNotification(type: (typeof NOTIFICATION_TYPE_VALUES)[number], metadata: Record<string, any>, options?: CreateOptions<any>): Promise<void>;
}
export {};
//# sourceMappingURL=Notification.d.ts.map