"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createProgramRegistry", {
    enumerable: true,
    get: function() {
        return createProgramRegistry;
    }
});
const _lodash = require("lodash");
const _index = require("../../fake/index.js");
const _programRegistry = require("@tamanu/constants/programRegistry");
const createProgramRegistry = async ({ models, limit, userId, patientId, programRegistryId, conditionCount = _index.chance.integer({
    min: 1,
    max: 5
}) })=>{
    const { ProgramRegistryCondition, ProgramRegistryConditionCategory, PatientProgramRegistration, PatientProgramRegistrationCondition } = models;
    const { id: patientProgramRegistrationId } = await PatientProgramRegistration.create((0, _index.fake)(PatientProgramRegistration, {
        clinicianId: userId,
        patientId,
        programRegistryId
    }));
    const condition = await ProgramRegistryCondition.create((0, _index.fake)(ProgramRegistryCondition, {
        programRegistryId
    }));
    const categoryCode = _programRegistry.PROGRAM_REGISTRY_CONDITION_CATEGORIES.UNKNOWN;
    const conditionCategory = await ProgramRegistryConditionCategory.create((0, _index.fake)(ProgramRegistryConditionCategory, {
        id: `program-registry-condition-category-${programRegistryId}-${categoryCode}`,
        code: categoryCode,
        name: _programRegistry.PROGRAM_REGISTRY_CONDITION_CATEGORY_LABELS[categoryCode],
        programRegistryId
    }));
    await Promise.all((0, _lodash.times)(conditionCount, ()=>limit(async ()=>{
            await PatientProgramRegistrationCondition.create((0, _index.fake)(PatientProgramRegistrationCondition, {
                patientProgramRegistrationId,
                programRegistryConditionId: condition.id,
                programRegistryConditionCategoryId: conditionCategory.id
            }));
        })));
};

//# sourceMappingURL=programRegistry.js.map